 ; Ŀ
 ;   Grayat - colour all attributes belonging to a given insert gray (8).  
 ;   Copyright 1998, 2006, 2010 by Rocket Software Ltd.                    
 ;   Also Contains:                                                        
 ;   A2, colour entities and attributes 252.                               
 ;   A3, colour entities and attributes 253.                               
 ;   A4, colour entities and attributes 254.                               
 ;   Gray, colour entities and attributes gray.                            
 ;   Oc, colour entities and attributes bylayer.                           
 ;   Gash, mark gray attributes and the entities which contain them.       
 ;   Gsh, mark gray entities.                                              
 ;                                                                         
 ;   Grayat.  Just grayat.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Cstar - draw an individual grstar (centred).               
 ;   Takes four arguments: centre point, side length, rotation (radians),  
 ;   and colour.  Returns nothing, but draws a star.                       
 ; 
 (DEFUN CSTAR (pa sidlen rota colo / anginc angg hafang pb)
  (setq pa (polar pa (+ rota (/ pi 2)) (* sidlen 1.37638192)))
  (setq anginc (* 1.6 pi))
  (setq angg (+ rota (* 1.6 pi)))
  (setq hafang (* 0.8 pi))
  (repeat 5
         (setq pb (polar pa angg sidlen))
         (grdraw pa pb colo)
         (setq angg (- angg anginc))
         (setq pa pb)
         (setq pb (polar pa angg sidlen))
         (grdraw pa pb colo)
         (setq angg (- angg hafang))
         (setq pa pb))
 (princ))
 ; Ŀ
 ;   Subroutine Cstar end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Gray - the engine.                                         
 ;   Arguments: Colo, the desired colour or 256 = Bylayer.                 
 ;              Para, t = gray the parent entity, nil = attributes only.   
 ;              Prom, the prompt substring.                                
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN GRAY (colo para prom / ss num enam entt esav asoc62)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (prompt (strcat "Select entities to " prom "."))
  (setq ss (ssget))
  (setq num 0)
  (while (and ss (setq esav (setq enam (ssname ss num))))
         (setq num (1+ num))
         (if para
             (if (= colo 256)
                 (command "change" enam "" "p" "colour" "bylayer" "")
                 (command "change" enam "" "p" "colour" colo "")))
         (setq entt (entget enam))
         (if (and (= (cdr (assoc 0 entt)) "INSERT")
                  (assoc 66 entt))
             (progn
                  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
                         (if (setq asoc62 (assoc 62 entt))
                             (setq entt (subst (cons 62 colo) asoc62 entt))
                             (setq entt (append entt (list (cons 62 colo)))))
                         (entmod entt))
                  (entupd esav))))
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   Subroutine Gray end.                                                  
 ; 

 ; Ŀ
 ;   Mark - mark a point.                                                  
 ;   Arguments: Pa - the point to mark.                                    
 ;              Rad - the marker segment length.                           
 ;              Colo - the marker grdraw line colour.                      
 ; 
 (DEFUN MARK (pa rad colo /)
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
 (princ))
 ; Ŀ
 ;   Mark end.                                                             
 ; 

 ; Ŀ
 ;   Gash - find blocks with gray attributes.                              
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN C:GASH (/ rad ss num found numa enam entt asoc62 numa pa bnum)
  (setvar "cmdecho" 0)
  (setq rad (/ (getvar "viewsize") 100))
  (setq ss (ssget "x" (list (cons 0 "INSERT") (cons 66 1))))
  (setq num 0)
  (setq numa 0)
  (setq bnum 0)
  (while (and ss (setq esav (setq enam (ssname ss num))))
         (setq num (1+ num))
         (setq found ())
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                           (setq enam (entnext enam)))))))
                (if (and (setq asoc62 (assoc 62 entt))
                         (member (cdr asoc62) '(8 9 251 252 253 254 255)))
                    (progn
                         (setq pa (cdr (assoc 10 entt)))
                         (cstar pa rad 0 2)
                         (setq found t)
                         (setq numa (1+ numa)))))
         (if found
             (progn
                  (mark (cdr (assoc 10 (entget esav)))
                        (/ (getvar "viewsize") 32) 1)
                  (setq bnum (1+ bnum)))))
  (write-line (strcat (itoa numa)
                      " Gray Attribute"
                      (if (= 1 numa) "" "s")
                      " in " (itoa bnum)
                      (if (= 1 bnum) " Block" " Blocks")
                      "."))
 (princ))

 ; Ŀ
 ;   Gsh: mark gray entities.                                              
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN C:GSH (/ rad ss num pa)
  (setq rad (/ (getvar "viewsize") 100))
  (setq ss (ssget "x" '((-4 . "<or") (62 . 8) (62 . 251) (62 . 252)
                                     (62 . 253) (62 . 254) (62 . 255)
                        (-4 . "or>"))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq pa (cdr (assoc 10 (entget enam))))
         (cstar pa rad 0 2))
  (write-line (strcat "Gray Entities Found: " (itoa num)))
 (princ))

 (DEFUN C:OC ()
  (gray 256 t "De-Gray")
 (princ))

 (DEFUN C:A2 ()
  (gray 252 t "Colour 252")
 (princ))

 (DEFUN C:A3 ()
  (gray 253 t "Colour 253")
 (princ))

 (DEFUN C:A4 ()
  (gray 254 t "Colour 254")
 (princ))

 (DEFUN C:GRAY ()
  (gray 8 t "Grey Out")
 (princ))

 (DEFUN C:GRAYAT ()
  (gray 8 nil "Grey Attributes")
 (princ))